/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.comm.TEInterface;
import com.quantumdata.sct.dao.impl.ModelDAO;
import com.quantumdata.sct.dao.impl.TestDAO;
import com.quantumdata.sct.dao.impl.TestResultsDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.CompositeStepVO;
import com.quantumdata.sct.dao.vo.GenericStepVO;
import com.quantumdata.sct.dao.vo.InputStepVO;
import com.quantumdata.sct.dao.vo.ModelVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestResultsVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class PrintReportDialog
extends JDialog
implements ActionListener {
    private JEditorPane reportPanel;
    private SCTButton cancelBtn;
    private SCTButton browseBtn;

    PrintReportDialog(JFrame jFrame) throws Exception {
        super((Frame)jFrame, true);
        this.getContentPane().setLayout(new BorderLayout());
        JEditorPane jEditorPane = this.getPrintArea();
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        Dimension dimension = new Dimension(800, 600);
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = this.getButtonArea();
        this.getContentPane().add((Component)jPanel, "South");
        this.setSize(dimension);
        this.setResizable(true);
        SCTConstants.screenCenterPlacement(this);
    }

    private JPanel getButtonArea() {
        SCTPanel sCTPanel = new SCTPanel();
        this.browseBtn = new SCTButton("Save...");
        this.browseBtn.addActionListener(this);
        sCTPanel.add(this.browseBtn);
        this.cancelBtn = new SCTButton("Cancel");
        this.cancelBtn.addActionListener(this);
        sCTPanel.add(this.cancelBtn);
        return sCTPanel;
    }

    private JEditorPane getPrintArea() throws Exception {
        ModelDAO modelDAO;
        IPersistable iPersistable;
        String string = SCTSelection.instance().getUnitID();
        String string2 = SCTSelection.instance().getModelID();
        ArrayList arrayList = null;
        if (SCTSelection.instance().getCurrentConnection() != null) {
            try {
                arrayList = TEInterface.instance().scanInstrument();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((iPersistable = (modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO()).findByPrimaryKey(string2)) instanceof ModelVO) {
            string2 = ((ModelVO)iPersistable).getName();
        }
        String string3 = SCTSelection.instance().getUnitSerial();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        stringBuffer.append("<b>Test results for model " + string2 + ", unit serial #" + string3 + "</b><br>");
        stringBuffer.append("<b>Report created using Quantum Data TME v." + SCTConstants.getReleaseVersion() + "<br>");
        if (arrayList != null) {
            stringBuffer.append("Equipment info: " + arrayList.get(0) + " " + arrayList.get(1) + ", serial #" + arrayList.get(2) + ", firmware ver. " + arrayList.get(3) + "</b><br>");
        } else {
            stringBuffer.append("Error: Test equipment information could not be retrieved.<br>");
        }
        TestResultsDAO testResultsDAO = (TestResultsDAO)XMLDAOFactory.getTestResultsDAO(SCTConstants.getUnitStorage(string));
        TestDAO testDAO = (TestDAO)XMLDAOFactory.getTestDAO();
        TestResultsVO testResultsVO = (TestResultsVO)testResultsDAO.getValueObjectForKey(string);
        for (TestResultVO testResultVO : testResultsVO.getStepresults()) {
            TestVO testVO = (TestVO)testDAO.getValueObjectForKey(testResultVO.getCapabilityId());
            stringBuffer.append("<table width=\"450\" border=\"0\">");
            stringBuffer.append("Compliance Test Section: " + testVO.getComplainceSectionId());
            stringBuffer.append("<br>Test Description: " + this.fixString(testVO.getDescription()));
            stringBuffer.append("<br>Status: " + testResultVO.getStatus());
            if (!testResultVO.getStatus().equalsIgnoreCase("PASS") && !testResultVO.getStatus().equalsIgnoreCase("NOT TESTED")) {
                stringBuffer.append("</table><table width=\"450\" border=\"1\"><tr><td><b>Step Description</b></td><td><b>Status</b></td></tr>");
                AbstractStepVO[] abstractStepVOArray = testVO.getStepsVO();
                for (int i = 0; i < abstractStepVOArray.length; ++i) {
                    this.printStep(abstractStepVOArray[i], testResultVO, stringBuffer);
                }
            }
            stringBuffer.append("</table><p>");
        }
        stringBuffer.append("</body></html>");
        this.reportPanel = new JEditorPane("text/html", stringBuffer.toString());
        return this.reportPanel;
    }

    private String fixString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '<') {
                string = string.subSequence(0, i) + "&lt;" + string.subSequence(i + 1, string.length());
                continue;
            }
            if (string.charAt(i) != '>') continue;
            string = string.subSequence(0, i) + "&gt;" + string.subSequence(i + 1, string.length());
        }
        return string;
    }

    private void printStep(AbstractStepVO abstractStepVO, TestResultVO testResultVO, StringBuffer stringBuffer) {
        if (abstractStepVO instanceof CompositeStepVO) {
            Iterator iterator = ((CompositeStepVO)abstractStepVO).getChildStepsList().iterator();
            while (iterator.hasNext()) {
                this.printStep((AbstractStepVO)iterator.next(), testResultVO, stringBuffer);
            }
        } else {
            if (abstractStepVO instanceof GenericStepVO) {
                return;
            }
            if (abstractStepVO instanceof InputStepVO) {
                stringBuffer.append("<tr><td>" + this.fixString(abstractStepVO.getDescription()));
                TestStepResultVO testStepResultVO = testResultVO.getTestStepResults(abstractStepVO.getId().toString());
                Object[] objectArray = testStepResultVO.getParameters().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(" " + ((ParameterVO)objectArray[i]).getValue());
                }
                if (testStepResultVO != null) {
                    stringBuffer.append("</td><td>" + testStepResultVO.getStatus() + "</td></tr>");
                } else {
                    stringBuffer.append("</td><td>Undefined</td></tr>");
                }
            } else {
                TestStepResultVO testStepResultVO = testResultVO.getTestStepResults(abstractStepVO.getId().toString());
                stringBuffer.append("<tr><td>" + this.fixString(abstractStepVO.getDescription()) + "</td><td>");
                if (testStepResultVO != null) {
                    stringBuffer.append(testStepResultVO.getStatus() + "</td></tr>");
                } else {
                    stringBuffer.append("Undefined</td></tr>");
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseBtn) {
            JFileChooser jFileChooser = new JFileChooser();
            StringBuffer stringBuffer = new StringBuffer(SCTSelection.instance().getModelID() + " " + SCTSelection.instance().getUnitSerial() + ".htm");
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) == ':') {
                    stringBuffer.setCharAt(i, '-');
                }
                if (stringBuffer.charAt(i) == ' ') {
                    stringBuffer.setCharAt(i, '_');
                }
                if (stringBuffer.charAt(i) == '/') {
                    stringBuffer.setCharAt(i, '-');
                }
                if (stringBuffer.charAt(i) != System.getProperty("file.separator").charAt(0)) continue;
                stringBuffer.setCharAt(i, '-');
            }
            jFileChooser.setSelectedFile(new File(stringBuffer.toString()));
            jFileChooser.addChoosableFileFilter(new HTMLFilter());
            if (jFileChooser.showSaveDialog(this.getParent()) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().endsWith("html") && !file.getName().endsWith("htm")) {
                    file = new File(file.getAbsolutePath() + ".htm");
                }
                this.saveReport(file);
            }
        } else if (actionEvent.getSource() == this.cancelBtn) {
            this.dispose();
        }
    }

    private void saveReport(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.reportPanel.getText().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.getParent(), "Error writing report to selected file");
        }
    }

    class HTMLFilter
    extends FileFilter {
        HTMLFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".htm") || string.endsWith(".html");
        }

        public String getDescription() {
            return "HTML files (*.htm, *.html)";
        }
    }

    class PrintableJEditorPane
    extends JEditorPane
    implements Printable {
        PrintableJEditorPane(String string, String string2) {
            super(string, string2);
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n == 0) {
                this.paint(graphics);
                return 0;
            }
            return 1;
        }
    }
}

